#!/usr/bin/python3
import numpy as np
import scipy.signal as signal
import matplotlib.pyplot as plt

# Read Results
data = np.loadtxt('./postProcessing/forceCoeffs/0/forceCoeffs.dat', skiprows=0)
L = 1 # L = D - Diameter
V = V = 1.1554 # Velocity
time = data[:,0]
Cd = data[:,2]
Cl = data[:,3]
del data

# Compute FFT
N = len(time)
dt = time[2] - time[1]

# Better stable FFT
nmax = 512 # no. of points in the fft
freq, Cd_amp = signal.welch(Cd, 1./dt, nperseg=nmax)
freq, Cl_amp = signal.welch(Cl, 1./dt, nperseg=nmax)

plt.plot(freq, Cl_amp)
plt.grid()
plt.title("Amplitude v/s Frequency")
plt.xlabel("Frequency")
plt.ylabel("Amplitude")
plt.show()

# Strouhal Number
# Find the index corresponding to max amplitude
Cl_max_fft_idx = np.argmax(abs(Cl_amp))
freq_shed = freq[Cl_max_fft_idx]
St = freq_shed * L / V
print("Vortex shedding freq: %.6f [Hz]" % (freq_shed))
print("Strouhal Number: %.6f" % (St))

# Time v/s Lift Coefficient
plt.plot(time, Cl)
plt.grid()
plt.title("Lift Coefficient v/s Time")
plt.xlabel("Time")
plt.ylabel("Lift Coefficient")
plt.show()

# Time v/s Drag Coefficient
plt.plot(time, Cd)
plt.grid()
plt.title("Drag Coefficient v/s Time")
plt.xlabel("Time")
plt.ylabel("Drag Coefficient")
plt.show()

# Calculate average after stabilization
stabilization_period = 1000 # Choose an appropriate stabilization period
avg_Cl = np.mean(Cl[stabilization_period:])
avg_Cd = np.mean(Cd[stabilization_period:])

print("Average Lift Coefficient after stabilization:", avg_Cl)
print("Average Drag Coefficient after stabilization:", avg_Cd)
