##import paraview.simple 
try:
	
	paraview.simple
	

except: 
	
	from paraview.simple import *

import csv
meshOpenFOAM1 = OpenFOAMReader(FileName='D:\\iitm_ms\SummerIntern3\\trianglefins\\q=1000\\foam.foam')
meshOpenFOAM1.MeshRegions = ['fluid/fluid_to_solid']
meshOpenFOAM1.CellArrays = ['T', 'U', 'grad(T)', 'grad(U)', 'grad(p)', 'p', 'p_rgh', 'rho', 'wallHeatFlux', 'wallShearStress', 'qr']


meshOpenFOAM2 = OpenFOAMReader(FileName='D:\\iitm_ms\SummerIntern3\\trianglefins\\q=1000\\foam.foam')
meshOpenFOAM2.MeshRegions = ['fluid/inlet', 'fluid/outlet', 'fluid/internalMesh']
meshOpenFOAM2.CellArrays = ['T', 'U', 'grad(T)', 'grad(U)', 'grad(p)', 'p', 'p_rgh', 'rho', 'wallShearStress', 'qr']



##source = GetActiveSource(meshOpenFOAM)

list1 = []
list2 = []
list3 = []
list4 = []
Tref = 296
heatflux = 1000 # change it for every case



#inlet slice to calculate inlet bulk mean temperature
extractBlock1 = ExtractBlock(Input=meshOpenFOAM2)
extractBlock1.BlockIndices = [5]
Calculator0 = Calculator(Input=extractBlock1)
Calculator0.ResultArrayName = 'Cp'
Calculator0.Function = '287*((((-3.87E-15*T+6.57E-11)*T-4.14E-07)*T+1.23E-03)*T+3.09589)'
Calculator1 = Calculator(Calculator0)
Calculator1.ResultArrayName = 'Result1'
Calculator1.Function = 'Cp*rho*U_Y*T'  
Calculator2 = Calculator(Input=Calculator1)
Calculator2.ResultArrayName = 'Result2'
Calculator2.Function = 'Cp*rho*U_Y'
IntegrateVariables1 = IntegrateVariables(Calculator2)
Calculator3 = Calculator(Input=IntegrateVariables1)
Calculator3.ResultArrayName='Tbin'
Calculator3.Function = 'Result1/Result2'
realCalculator1=servermanager.Fetch(Calculator3)
rcPointData1=realCalculator1.GetPointData()
Result2Array1=rcPointData1.GetArray('Tbin')
Tbin = Result2Array1.GetValue(0)
y = 'T_inlet'
list1.append(y)
list2.append(Tbin)
#print('inlet_temperature =', Tbin)


#outlet slice to calculate outlet bulk mean temperature 
extractBlock2 = ExtractBlock(Input=meshOpenFOAM2)
extractBlock2.BlockIndices = [6]
Calculator4 = Calculator(Input=extractBlock2)
Calculator4.ResultArrayName = 'Cp'
Calculator4.Function = '287*((((-3.87E-15*T+6.57E-11)*T-4.14E-07)*T+1.23E-03)*T+3.09589)'
Calculator5 = Calculator(Input=Calculator4)
Calculator5.ResultArrayName = 'Result1'
Calculator5.Function = 'Cp*rho*U_Y*T'   
Calculator6 = Calculator(Input=Calculator5)
Calculator6.ResultArrayName = 'Result2'
Calculator6.Function = 'Cp*rho*U_Y'
IntegrateVariables2 = IntegrateVariables(Calculator6)
Calculator7 = Calculator(Input=IntegrateVariables2)
Calculator7.ResultArrayName='Tbout'
Calculator7.Function = 'Result1/Result2'
realCalculator2=servermanager.Fetch(Calculator7)
rcPointData2=realCalculator2.GetPointData()
Result2Array2=rcPointData2.GetArray('Tbout')
Tbout = Result2Array2.GetValue(0)
y = 'T_outlet'
list1.append(y)
list2.append(Tbout)
#print(list1)
#print('outlet_temperature =', Tbout)

#average wall temperature, heat transfer coefficient 296 is inlet reference temperature

#create a new 'Clip'
clip1 = Clip(Input=meshOpenFOAM1)
clip1.ClipType = 'Plane'
clip1.ClipType.Origin = [0.05000000074505806, 0.5, 0.0024999999441206455]
clip1.ClipType.Normal = [0.0, -1.0, 0.0]

# create a new 'Clip'
clip2 = Clip(Input=clip1)
clip2.ClipType = 'Plane'
clip2.ClipType.Origin = [0.05000000074505806, 2.5, 0.0024999999441206455]
clip2.ClipType.Normal = [0.0, 1.0, 0.0]

Calculator8 = Calculator(Input=clip2)
Calculator8.ResultArrayName = 'Cp'
Calculator8.Function = '287*((((-3.87E-15*T+6.57E-11)*T-4.14E-07)*T+1.23E-03)*T+3.09589)'
Calculator9 = Calculator(Input=Calculator8)
Calculator9.ResultArrayName = 'mue'
Calculator9.Function = '(1.46E-06*(T^1.5))/(110.4+T)'
Calculator10 = Calculator(Input=Calculator9)
Calculator10.ResultArrayName = 'ktherm'
Calculator10.Function = 'mue*(Cp-(8314/28.96))*(1.32+((1.77)/((Cp*28.96/8314)-1)))'
Calculator11 = Calculator(Input=Calculator10)
Calculator11.ResultArrayName = 'local Nusselt Number'
Calculator11.Function = '((wallHeatFlux-qr)*0.1)/(ktherm*(T-296))'
IntegrateVariables3 = IntegrateVariables(Calculator11)
r1=servermanager.Fetch(IntegrateVariables3).GetPointData().GetArray('local Nusselt Number')
integrateNu = r1.GetValue(0)
r2=servermanager.Fetch(IntegrateVariables3).GetCellData().GetArray('Area')
AREA1_fluid_to_solid = r2.GetValue(0)
AvgNu = integrateNu/AREA1_fluid_to_solid
#print(integrateNu)
#print(AREA1_fluid_to_solid)
IntegrateVariables4 = IntegrateVariables(Input=meshOpenFOAM1)
r3=servermanager.Fetch(IntegrateVariables4).GetPointData().GetArray('T')
integrateSurfaceTemp = r3.GetValue(0)
r4=servermanager.Fetch(IntegrateVariables4).GetCellData().GetArray('Area')
AREA2_fluid_to_solid = r4.GetValue(0)
AvgSurfTemp = integrateSurfaceTemp/AREA2_fluid_to_solid
y = 'AvgSurfTemp'
list1.append(y)
list2.append(AvgSurfTemp)


Tf = 0.5*(Tref+AvgSurfTemp)#Tf is Tbetafilm
beta = 1/Tf
rhof = (101325/(287*Tf)) # density at film temperature
#CP janaf coefficinets
a0 = 3.4002706656
a1 = 0.0004831957424
a2 = -0.0000010630119579
a3 = 0.0000000024237248811
a4 = -1.2502517023e-12
Cpf = (287*((((a4*Tf+a3)*Tf+a2)*Tf+a1)*Tf+a0)) # CP at film temperature
muef = (1.46e-06*(pow(Tf,1.5)))/(110.4+Tf) # dynamic viscosity at film temperature
kf = (muef*(Cpf-(8314/28.96))*(1.32+((1.77)/((Cpf*28.96/8314)-1)))) # euken thermal conductivity at film temperature
nuf = muef/rhof # kinematic viscosity at film temperature
alphaf = (kf/(rhof*Cpf)) # thermal diffusivity at film temperature
g = 9.81 # acceleration due to gravity
#Modified Rayleigh number
# actual hydraulic diameter is 0.1, but due to wrong calculation in paper
# 1.0 is used only for calculation purpose
Dh = 1.0
Ram = (g*beta*heatflux*(pow(Dh,4))/(kf*nuf*alphaf))
Ram2 = Ram*pow(10,-11)
y = 'Tbetafilm'
list1.append(y)
list2.append(Tf)
y = 'rhof'
list1.append(y)
list2.append(rhof)
y = 'Cpf'
list1.append(y)
list2.append(Cpf)
y = 'muef'
list1.append(y)
list2.append(muef)
y = 'kf'
list1.append(y)
list2.append(kf)
y = 'nuf'
list1.append(y)
list2.append(nuf)
y = 'alphaf'
list1.append(y)
list2.append(alphaf)
y = 'Modified_Rayleigh_number(Ra*)'
list1.append(y)
list2.append(Ram)
y = 'Ra*/10^11'
list1.append(y)
list2.append(Ram2)
y = 'Avg Nusselt Number'
list1.append(y)
list2.append(AvgNu)


writer = CreateWriter("Post.csv")
with open('Post.csv', 'w') as f:
    csvwriter = csv.writer(f, delimiter=',')
    zippedlists = zip(list1,list2)
    for row in zippedlists:
        print (row)
        csvwriter.writerow(row)

