clear all

%% Time specifications:

Fs = 1/(0.001);               % samples per second
dt = 1/Fs;                    % seconds per sample
StopTime = 4.25;           % seconds
t = (0.001:dt:StopTime)';
N = size(t,1);

%% Read Data:

A =  readtable('p.csv');
x1 = table2array(A);

x2(:,1) = x1(1:N-1,1);
x2(:,2) = diff(x1(1:N,2))./dt; %2D
x2(:,3) = diff(x1(1:N,3))./dt; %4D
x2(:,4) = diff(x1(1:N,4))./dt; %6D

x3(:,1) = 1/Fs:1/Fs:0.86;
x3(:,2) = tsa(x2(1:4249,3),Fs,0.86);
N2 = size(x3(:,1),1);

%% Fourier Transform:
X = fftshift(fft(x3(1:N2-1,2)));

%% Frequency specifications:
dF = Fs/N2;                      % hertz
f = 0:dF:(Fs-1)/2;           	   % hertz

E = smoothdata(X,'gaussian',1);

%% Plot the spectrum:

g=figure();
loglog(f*0.02/0.683,abs(E(N2/2:N2-1,1))/N2);
xlim([0.01 20])
ylim([10^(-4) 100])
xlabel('St');
ylabel('<dP/dt>');
title('St = 70%, L = 2D, Z = 4D');
set(gca,'linewidth',2,'FontSize',16,'FontWeight','bold');

saveas(g,'70p_L2_X4D.png');

%% Calculate Break Frequency
fb              = sqrt( trapz(f'.*f',(f'.*f').*abs(E(N2/2:N2-1,1)).^2/(N2/2))/trapz(f'.*f',abs(E(N2/2:N2-1,1)).^2/(N2/2)) );

Stb             = fb*0.02/0.683;
fbc             = Stb*0.683/0.02;
St2_theory      = (0.5)^0.13;
St2_numerical   = fb*0.01/2.4;

%% Plot Spectrogram
x2(:,3) = smoothdata(x2(:,3),'gaussian',5);

h=figure();
pspectrum(x2(1:N-1,3),Fs,'spectrogram','FrequencyResolution',5,'OverlapPercent',99,'MinTHreshold',-10)
ylim([0 500])
title('St = 70%, L = 2D, Z = 4D');
set(gca,'linewidth',2,'FontSize',14,'FontWeight','bold');

saveas(h,'70p_L2_spect_X4D.png');
