/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2011-2021 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Application
    newScalarTransportFoam

Description
    Solves the scalar transport equation to simulate chemical reaction

\*---------------------------------------------------------------------------*/

#include "fvCFD.H"
#include "fvModels.H"
#include "fvConstraints.H"
#include "simpleControl.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

int main(int argc, char *argv[])
{
    #include "setRootCaseLists.H"
    #include "createTime.H"
    #include "createMesh.H"

    simpleControl simple(mesh);

    #include "createFields.H"

    // * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

    Info<< "\nCalculating scalar transport\n" << endl;

    #include "CourantNo.H"

    while (simple.loop(runTime))
    {
        Info<< "Time = " << runTime.timeName() << nl << endl;

        fvModels.correct();
        #include "CourantNo.H"

        while (simple.correctNonOrthogonal())
        {
            fvScalarMatrix scalar1Eqn
            (
                fvm::ddt(scalar1)
              + fvm::div(phi, scalar1)
              - fvm::laplacian(DS1, scalar1)
             ==
                -kS*scalar1*scalar2
            );
            
            fvScalarMatrix scalar2Eqn
            (
                fvm::ddt(scalar2)
              + fvm::div(phi, scalar2)
              - fvm::laplacian(DS2, scalar2)
             ==
                -kS*scalar1*scalar2
            );
            
            fvScalarMatrix scalar3Eqn
            (
                fvm::ddt(scalar3)
              + fvm::div(phi, scalar3)
              - fvm::laplacian(DS3, scalar3)
             ==
                kS*scalar1*scalar2
            );

            scalar1Eqn.relax();
            fvConstraints.constrain(scalar1Eqn);
            scalar1Eqn.solve();
            fvConstraints.constrain(scalar1);
            
            scalar2Eqn.relax();
            fvConstraints.constrain(scalar2Eqn);
            scalar2Eqn.solve();
            fvConstraints.constrain(scalar2);

            scalar3Eqn.relax();
            fvConstraints.constrain(scalar3Eqn);
            scalar3Eqn.solve();
            fvConstraints.constrain(scalar3);            
                        
        }

        runTime.write();
    }

    Info<< "End\n" << endl;

    return 0;
}


// ************************************************************************* //
