import numpy as np
from matplotlib import pyplot as plt
import csv
with open('radial.csv') as csvfile:
    readCSV = csv.reader(csvfile, delimiter=',')
    p=[];Ux=[];Uy=[];Uz=[];r=[];

    for row in list(readCSV)[2:502]:            

                    
            p=np.append(p,row[0])
	    Ux=np.append(Ux,row[1])
	    Uy=np.append(Uy,row[2])
            Uz=np.append(Uz,row[3])
            r=np.append(r,row[5])


#Analytical
r = [float(m) for m in r]   #Radial Distance
Uz = [float(n) for n in Uz] 
d=0.05			  #Diameter of the pipe
R=d/2.0			  #Radius of the pipe
a = np.divide(r, R) 
a= 1.0 - a
b=0.142857142		   #(1/7)
def Average(lst): 
    return sum(lst) / len(lst) 
U = Average(Uz) 	   #Average radial velocity at mid section
bracket = [x**b for x in a]
factor = 1.25*U
result = [x * factor for x in bracket]
result=np.negative(result)


#OpenFOAM
W = [float(k) for k in Uz]

Uz = np.negative(W)  
def Reverse(lst): 
    return [ele for ele in reversed(lst)]
Uz = Reverse(Uz)


plt.figure(1)
plt.plot(r, result, 'k.:',label='Analytical')
plt.plot(r, Uz, 'r.:',label='OpenFOAM')
legend = plt.legend(loc='upper right', shadow=True)
plt.ylabel('Axial Velocity (m/s)')
plt.xlabel('Radial Distance (m)')
plt.grid('on')
plt.savefig('Axialvel_at Radiallocation_comparison.eps')
plt.show()




























#U = [float(i) for i in Ux]
#V = [float(j) for j in Uy]
#W = [float(k) for k in Uz]
#l = [float(m) for m in l]
#def Reverse(lst): 
 #   return [ele for ele in reversed(lst)]


#P = [float(m) for m in p]
#P = Reverse(P)
#usq = [x**2 for x in U]
#vsq = [y**2 for y in V]
#wsq = [z**2 for z in W]

#Umag= [sum(x) for x in zip(usq, vsq, wsq)]

#f=0.0309  #Darcy Friction factor for Re = 10,000 from Moody chart
#rho=1000.0 #Density of Water
#d=0.05  #Diameter of pipe
#factor=((f*rho*0.2*0.2)/(2*d))/(rho)  #we are dividing by rho for consistency, since in OpenFOAM incompressible solver, pressure is divided by density
##print Umag

#delP = [i * i for i in Umag]

#result = [x * factor for x in l]

#result = Reverse(result)
#plt.figure(1)
#plt.plot(l, result, 'k.:',label='Analytical')
#plt.plot(l, P, 'r.:',label='OpenFOAM')
#legend = plt.legend(loc='upper right', shadow=True)
#plt.ylabel('delP')
#plt.xlabel('Length')
#plt.grid('on')
#plt.savefig('Pressure_drop_comparison.eps')
#plt.show()




