Info<< "Reading field scalar1\n" << endl;

volScalarField scalar1
(
    IOobject
    (
        "scalar1",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);

Info<< "Reading field scalar2\n" << endl;

volScalarField scalar2
(
    IOobject
    (
        "scalar2",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);


Info<< "Reading field U\n" << endl;

volVectorField U
(
    IOobject
    (
        "U",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);


Info<< "Reading transportProperties\n" << endl;

IOdictionary transportProperties
(
    IOobject
    (
        "transportProperties",
        runTime.constant(),
        mesh,
        IOobject::MUST_READ_IF_MODIFIED,
        IOobject::NO_WRITE
    )
);


Info<< "Reading diffusivity DS1\n" << endl;

dimensionedScalar DS1
(
    "DS1",
    transportProperties.lookup("DS1")
);

Info<< "Reading diffusivity DS2\n" << endl;

dimensionedScalar DS2
(
    "DS2",
    transportProperties.lookup("DS2")
);


Info<< "Reading Reaction Rate kS\n" << endl;

dimensionedScalar kS
(
    "kS",
    transportProperties.lookup("kS")
);

#include "createPhi.H"

#include "createFvModels.H"
#include "createFvConstraints.H"
