Info<< "Reading field scalar1\n" << endl;

volScalarField scalar1
(
    IOobject
    (
        "scalar1",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);


Info<< "Reading field U\n" << endl;

volVectorField U
(
    IOobject
    (
        "U",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);


Info<< "Reading transportProperties\n" << endl;

IOdictionary transportProperties
(
    IOobject
    (
        "transportProperties",
        runTime.constant(),
        mesh,
        IOobject::MUST_READ_IF_MODIFIED,
        IOobject::NO_WRITE
    )
);


Info<< "Reading diffusivity DS1\n" << endl;

dimensionedScalar DS1
(
    "DS1",
    transportProperties.lookup("DS1")
);

Info<< "Reading Reaction Rate kS1\n" << endl;

dimensionedScalar kS1
(
    "kS1",
    transportProperties.lookup("kS1")
);

#include "createPhi.H"

#include "createFvModels.H"
#include "createFvConstraints.H"
