import csv
import matplotlib.pyplot as plt

##---------------------------------------------------------------------------##
##---------------------------------------------------------------------------##

def csvparsing(xf,ty, a, b):
    x = [];
    y = [];
    with open(xf) as File:  
        reader = csv.reader(File)
        for row in reader:
            x.append(row[a])
            y.append(row[b])
    if ty == 'sim':
        xFinal = [10*float(i) for i in x[1::]]
        ynFinal = [100*float(i) for i in y[1::]]
    else:
        xFinal = [float(i) for i in x[1::]]
        ynFinal = [float(i) for i in y[1::]]
        
    yFinal = [i/max(ynFinal) for i in ynFinal]
    
    return xFinal,yFinal

##---------------------------------------------------------------------------##
fig, axs = plt.subplots(2, 2)

axs[0, 0].plot(csvparsing("paper/N0/velmidwidth.csv",'paper',0,1)[0],
         csvparsing("paper/N0/velmidwidth.csv",'paper',0,1)[1],color='k')
axs[0, 0].plot(csvparsing("sim/nnewt/N0/velmidwidth.csv",'sim',0,1)[1], 
         csvparsing("sim/nnewt/N0/velmidwidth.csv",'sim',0,1)[0],'--',color='k')
axs[0, 0].set_title('N = 0, non-Newtonian')

axs[0, 1].plot(csvparsing("paper/N1/velmidwidth.csv",'paper',0,1)[0],
         csvparsing("paper/N1/velmidwidth.csv",'paper',0,1)[1],color='r')
axs[0, 1].plot(csvparsing("sim/nnewt/N1/velmidwidth.csv",'sim',0,1)[1], 
         csvparsing("sim/nnewt/N1/velmidwidth.csv",'sim',0,1)[0],'--',color='r')
axs[0, 1].set_title('N = 0, non-Newtonian')

axs[1, 0].plot(csvparsing("paper/N10/velmidwidth.csv",'paper',0,1)[0],
         csvparsing("paper/N10/velmidwidth.csv",'paper',0,1)[1],color='b')
axs[1, 0].plot(csvparsing("sim/nnewt/N10/velmidwidth.csv",'sim',0,1)[1], 
         csvparsing("sim/nnewt/N10/velmidwidth.csv",'sim',0,1)[0],'--',color='b')
axs[1, 0].set_title('N = 0, non-Newtonian')

axs[1, 1].plot(csvparsing("paper/N50/velmidwidth.csv",'paper',0,1)[0],
         csvparsing("paper/N50/velmidwidth.csv",'paper',0,1)[1],color='g')
axs[1, 1].plot(csvparsing("sim/nnewt/N50/velmidwidth.csv",'sim',0,1)[1], 
         csvparsing("sim/nnewt/N50/velmidwidth.csv",'sim',0,1)[0],'--',color='g')
axs[1, 1].set_title('N = 0, non-Newtonian')

for ax in axs.flat:
    ax.set(xlabel='Relative velocity $V_x/V_{x,max}$', ylabel='Cavity height, $y/L$')
    ax.grid("true")
    ax.set_xlim([-1,1])
    ax.set_ylim([0,1])

# Hide x labels and tick labels for top plots and y ticks for right plots.
for ax in axs.flat:
    ax.label_outer()
    
##---------------------------------------------------------------------------##    
fig, axs = plt.subplots(2, 2)

axs[0, 0].plot(csvparsing("sim/newt/N0/velmidwidth.csv",'sim',0,1)[1],
         csvparsing("sim/newt/N0/velmidwidth.csv",'sim',0,1)[0],color='k')
axs[0, 0].plot(csvparsing("sim/nnewt/N0/velmidwidth.csv",'sim',0,1)[1], 
         csvparsing("sim/nnewt/N0/velmidwidth.csv",'sim',0,1)[0],'--',color='k')
axs[0, 0].set_title('N = 0')

axs[0, 1].plot(csvparsing("sim/newt/N1/velmidwidth.csv",'sim',0,1)[1],
         csvparsing("sim/newt/N1/velmidwidth.csv",'sim',0,1)[0],color='r')
axs[0, 1].plot(csvparsing("sim/nnewt/N1/velmidwidth.csv",'sim',0,1)[1], 
         csvparsing("sim/nnewt/N1/velmidwidth.csv",'sim',0,1)[0],'--',color='r')
axs[0, 1].set_title('N = 1')

axs[1, 0].plot(csvparsing("sim/newt/N10/velmidwidth.csv",'sim',0,1)[1],
         csvparsing("sim/newt/N10/velmidwidth.csv",'sim',0,1)[0],color='b')
axs[1, 0].plot(csvparsing("sim/nnewt/N10/velmidwidth.csv",'sim',0,1)[1], 
         csvparsing("sim/nnewt/N10/velmidwidth.csv",'sim',0,1)[0],'--',color='b')
axs[1, 0].set_title('N = 10')

axs[1, 1].plot(csvparsing("sim/newt/N50/velmidwidth.csv",'sim',0,1)[1],
         csvparsing("sim/newt/N50/velmidwidth.csv",'sim',0,1)[0],color='g')
axs[1, 1].plot(csvparsing("sim/nnewt/N50/velmidwidth.csv",'sim',0,1)[1], 
         csvparsing("sim/nnewt/N50/velmidwidth.csv",'sim',0,1)[0],'--',color='g')
axs[1, 1].set_title('N = 50')

for ax in axs.flat:
    ax.set(xlabel='Relative velocity $V_x/V_{x,max}$',
    ylabel='Cavity height, $y/L$')
    ax.grid("true")
    ax.set_xlim([-1,1])
    ax.set_ylim([0,1])

for ax in axs.flat:
    ax.label_outer()

##---------------------------------------------------------------------------##
plt.figure(3)

plt.plot(csvparsing("sim/nnewt/N50/velmidwidth.csv",'sim',0,1)[1],
         csvparsing("sim/nnewt/N50/velmidwidth.csv",'sim',0,1)[0],color='k',
         label = "Mesh no. 1")

plt.plot(csvparsing("sim/nnewt/N50G1/velmidwidth.csv",'sim',0,1)[1],
         csvparsing("sim/nnewt/N50G1/velmidwidth.csv",'sim',0,1)[0],color='b',
         label = "Mesh no. 2")
plt.grid("true")
plt.xlabel("Relative velocity $V_x/V_{x,max}$")
plt.ylabel("Cavity height $y/L$")
plt.xlim([-1,1])
plt.ylim([0,1])
plt.legend()
plt.show()