import os
import csv
import matplotlib.pylab as py
import numpy as np
from numpy import math
# y = np.linspace(-1,0, 200)
# z = np.linspace(0.00005,1,199)
y=[]
z=[]
with open ('negativePoints.csv','r') as csv1:
    r1 = csv.reader(csv1, delimiter = ',')
    for line in r1:
        i=line[0]
        y.append(float(i))
with open ('positivePoints.csv','r') as csv1:
    r1 = csv.reader(csv1, delimiter = ',')
    for line in r1:
        i=line[0]
        z.append(float(i))
n= np.concatenate((y,z), axis=0)
uth1=[]
uth2=[]
uth=[]
u_x=[]
t=[]
ha=500
for x in z:
    e=-2*ha
    c=(ha+1)/(ha-1)
    d= 1 + np.exp(e)
    a= (ha/(ha-1))*(1+np.exp(e))/(1+c*np.exp(e))
    f = (1+np.exp(e*x))
    g = np.exp(ha*(x-1))/d
    b= a*(1-f*g)
    uth1.append(b)
for x in y:
    e=-2*ha
    c=(ha+1)/(ha-1)
    d= 1 + np.exp(e)
    a= (ha/(ha-1))*(1+np.exp(e))/(1+c*np.exp(e))
    f= (1+np.exp(2*ha*x))
    g= np.exp(-ha*(x+1))/d
    b= a*(1-f*g)
    uth2.append(b)
with open ('Ux_data_500.csv','r') as csv2:
    r2 = csv.reader(csv2, delimiter = ',')
    for line in r2:
        i=line[1]
        j=line[0]
        u_x.append(float(i))
        t.append(float(j))
uth=np.concatenate((uth2,uth1), axis=0)
s1=[abs(u_x[i]-uth[i]) for i in range(len(uth))]
py.figure(1)
py.plot(n, uth,'.', label ='theoretical solution')
py.plot(n, u_x, '*', label ='simulation result')
py.legend(loc='lower center', fontsize=15)
py.ylabel('U(x)', fontsize=20)
py.xlabel('arc-length', fontsize=20)
py.title('Ux plots for Ha=500', fontsize=25)
py.figure(2)
py.plot(n,s1,'.')
py.xlabel('arc-length', fontsize=20)
py.ylabel('Error magnitude', fontsize=20)
py.title('Error plot for Ha=500', fontsize=25)
py.show()
