Info<< "Reading field scalar1\n" << endl;

volScalarField scalar1
(
    IOobject
    (
        "scalar1",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);

Info<< "Reading field scalar2\n" << endl;

volScalarField scalar2
(
    IOobject
    (
        "scalar2",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);


Info<< "Reading field U\n" << endl;

volVectorField U
(
    IOobject
    (
        "U",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);


Info<< "Reading transportProperties\n" << endl;

IOdictionary transportProperties
(
    IOobject
    (
        "transportProperties",
        runTime.constant(),
        mesh,
        IOobject::MUST_READ_IF_MODIFIED,
        IOobject::NO_WRITE
    )
);


Info<< "Reading diffusivity DS1\n" << endl;

dimensionedScalar DS1
(
    "DS1",
    transportProperties.lookup("DS1")
);

Info<< "Reading diffusivity DS2\n" << endl;

dimensionedScalar DS2
(
    "DS2",
    transportProperties.lookup("DS2")
);

// Temperature field (for Arrhenius)
Info<< "Reading temperature field T\n" << endl;
volScalarField T
(
    IOobject
    (
        "T",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);

// Arrhenius coefficients
dimensionedScalar rho("rho", dimDensity, transportProperties);
dimensionedScalar Cp("Cp", dimSpecificHeatCapacity, transportProperties);
dimensionedScalar kappa("kappa", dimPower/dimLength/dimTemperature, transportProperties);
Info<< "Reading Arrhenius coefficients\n" << endl;
const dictionary& kSDict = transportProperties.subDict("kS");
dimensionedScalar A("A", dimless/dimTime, kSDict.lookup("A"));
dimensionedScalar Ea("Ea", dimEnergy/dimMoles, kSDict.lookup("Ea"));
dimensionedScalar R("R", dimEnergy/dimMoles/dimTemperature, kSDict.lookup("R"));

// Reaction rate field (initialization, will be updated in solver)
Info<< "Creating reaction rate field kS\n" << endl;
volScalarField kS
(
    IOobject
    (
        "kS",
        runTime.timeName(),
        mesh,
        IOobject::NO_READ,
        IOobject::AUTO_WRITE
    ),
    mesh,
    dimensionedScalar("kS", dimless/dimTime, 0)
);

#include "createPhi.H"

#include "createFvModels.H"
#include "createFvConstraints.H"

