
Include "naca_airfoil.geo";

// Fluid Domain
y_max = 400;
x_max = 700;

// Mesh parameters
n_inlet = 200;      
n_vertical = 200;   
r_vertical_top = 1/0.97;    
r_vertical_low = 1/1.03;    
n_airfoil = 150;    
n_wake = 175;       
r_wake_top = 1;  
r_wake_bottom = 1; 

// Points
Point(200) = {x_max, y_max, 0};
Point(201) = {x_max, -y_max, 0};
Point(202) = {x_max, 0, 0};
Point(203) = {-2, y_max, 0};
Point(204) = {-2, -y_max, 0};
Point(205) = {100, y_max, 0};
Point(206) = {100, -y_max, 0};



// Curves
Circle(2) = {204, 100, 203};
Line(3) = {203, 205};
Line(4) = {205, 200};
Line(5) = {200, 202};
Line(6) = {202, 201};
Line(7) = {201, 206};
Line(8) = {206, 204};
Line(9) = {129, 204};
Line(10) = {71, 203};
Line(13) = {1, 202};
Line(14) = {205, 1};
Line(15) = {1, 206};

// Split airfoil curve
Split Curve {1} Point {71, 129};
Split Curve {17} Point {1};

// Transfinite meshing for curves
Transfinite Curve {2, 16} = n_inlet Using Progression 1;
Transfinite Curve {10} = n_vertical Using Progression r_vertical_top;
Transfinite Curve {14} = n_vertical Using Progression r_vertical_low;
Transfinite Curve {5} = n_vertical Using Progression r_vertical_low;
Transfinite Curve {9} = n_vertical Using Progression r_vertical_top;
Transfinite Curve {15} = n_vertical Using Progression r_vertical_top;
Transfinite Curve {6} = n_vertical Using Progression r_vertical_top;
Transfinite Curve {8,3,18,19} = n_airfoil Using Progression 1;
Transfinite Curve {4} = n_wake Using Progression r_wake_top;
Transfinite Curve {13} = n_wake Using Progression r_wake_top;
Transfinite Curve {7} = n_wake Using Progression r_wake_bottom;

// Curve loops and surfaces
Curve Loop(1) = {2, -10, 16, 9};
Plane Surface(1) = {1};
Curve Loop(2) = {10, 3, 14,19};
Plane Surface(2) = {2};
Curve Loop(3) = {14, 13, -5, -4};
Plane Surface(3) = {3};
Curve Loop(4) = {6, 7, -15, 13};
Plane Surface(4) = {4};
Curve Loop(5) = {18, 15, 8, -9};
Plane Surface(5) = {5};



// Transfinite surfaces
//+
Transfinite Surface {1};
//+
Transfinite Surface {2};
//+ 
Transfinite Surface {3};
//+
Transfinite Surface {4};
//+
Transfinite Surface {5};


// Recombine for quadrilateral elements
Recombine Surface {1, 2, 3, 4, 5};
//+
Extrude {0, 0, 10} {
  Surface{1}; Surface{2}; Surface{3}; Surface{4}; Surface{5}; Layers {1}; Recombine;
}

//+
Physical Surface("inlet", 130) = {28,54, 84, 124, 98};
//+
Physical Surface("outlet", 132) = {80, 94};
//+
Physical Surface("walls", 135) = {62, 36, 116};
//+
Surface Loop(1) = {41, 28, 1, 36, 63, 54, 2, 62, 85, 80, 3, 84, 4, 94, 98, 107, 5, 116, 129, 124};
//+
Physical Volume("fluid", 136) = {1, 2, 3, 4, 5};
//+
Physical Surface("back", 137) = {4, 3, 1, 5, 2};
//+
Physical Surface("front", 138) = {41, 85, 107, 63, 129};