import pandas as pd
import matplotlib.pyplot as plt

# Load the data
df = pd.read_csv('pressure_along_x_at_t__1sec.csv')

# Create the plot using Matplotlib
plt.figure(figsize=(10, 6))
plt.plot(df['Points:0'], df['p'])

# Add labels and title
plt.xlabel('X (m)')
plt.ylabel('P (Pa)')
plt.grid(False)

# Save the plot
plt.savefig('pressure_vs_points_matplotlib.png',dpi =200)
