import matplotlib.pyplot as plt
import numpy as np

# Read the data from the file
# Skip the first 4 rows which contain header information
data = np.loadtxt('moment .txt', skiprows=4)

# Extract 'Time' (first column, index 0)
time = data[:, 0]
# Extract 'total_z' (fourth column, index 3)
total_z_moment = data[:, 3]

# Create the plot
plt.figure(figsize=(10, 6))
plt.plot(time, total_z_moment, linestyle='-')
plt.xlabel('Time (s)')
plt.ylabel('Moment (N.m)')
plt.grid(False)
plt.tight_layout()

# Save the plot
plt.savefig('time_vs_total_z_moment.png',dpi =200)

print("Plot saved as time_vs_total_z_moment.png")
