import pandas as pd
import matplotlib.pyplot as plt

# Read the CSV file into a DataFrame
df = pd.read_csv('data.csv')

# Create a figure with two subplots arranged side by side
fig, axes = plt.subplots(1, 2, figsize=(16, 6)) # 1 row, 2 columns, increased width for side-by-side

# Plot velocity on the first subplot (axes[0])
axes[0].plot(df['Distance from left wall'], df['Analytical_velocity'], label='Analytical')
axes[0].plot(df['Distance from left wall'], df['Simulation_velocity'], label='Simulation', linestyle='--')
axes[0].set_xlabel('X (m)')
axes[0].set_ylabel('u (m/s)')

axes[0].legend()
axes[0].grid(False) # Remove gridlines
axes[0].spines['right'].set_visible(True) # Ensure all four spines are visible
axes[0].spines['top'].set_visible(True)

# Plot pressure on the second subplot (axes[1])
axes[1].plot(df['Distance from left wall'], df['Analytical_pressure'], label='Analytical ')
axes[1].plot(df['Distance from left wall'], df['Simulation_pressure'], label='Simulation ', linestyle='--')
axes[1].set_xlabel('X (m)')
axes[1].set_ylabel('P (Pa)')

axes[1].legend()
axes[1].grid(False) # Remove gridlines
axes[1].spines['right'].set_visible(True) # Ensure all four spines are visible
axes[1].spines['top'].set_visible(True)

# Adjust layout to prevent overlapping titles/labels
plt.tight_layout()

# Save the combined plot
plt.savefig('nu1_100.png', dpi =200)
plt.close(fig) # Close the figure to free up memory

print("Combined plot saved as 'velocity_pressure_combined_side_by_side_plot.png'")
