clear 
clc



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % coefficient of pressure
% A=[6 7 3 4 5];                       %timestep
A=[7 6 4 3 2];  
V = [4.606 2.303 1.51 0.755 0.3775];        %flow velovity corresponding to chosen reynolds numbers
figure;
hold on;
box on;


J = readmatrix(append('expt1.csv')) ;   %reading experiment data
K = readmatrix(append('LES.csv')) ;   %reading LES data

markerStyles = {'ob', 'sg', '^m', '*c', 'xk','+r'}; 


for a = 1:length(A)
    O = readmatrix(append('k_',int2str(0),' (',int2str(A(a)),').csv'))  ;   
for k= 1:length(O)
       for l = 1714:1999    %%% choosing last 20s timesteps
    M = readmatrix(append('k_',int2str(l),' (',int2str(A(a)),').csv')) ;
    cp(k,l-1713) = M(k,4);
  
%    disp(k)
   
       end
end %finding length of data
 disp(a)
avg=mean(cp,2);   %%averaging Cp value over the surface for 20s
plot(((1*M( :,1)/.441)+1)/2,avg( :,1)*2/(1.204*V(a)^2),markerStyles{a}, 'MarkerSize', 10) %1.204
end

plot(J( :,1),J( :,2),'.r','MarkerSize',25)%%plotting experiment data

lgd=legend('Re=300000','Re=150000','Re=100000','Re=50000','Re=25000','Fage & Johansen (1927)', 'Location','northeast','FontSize',10);

 xlabel('x/b')             
ylabel('C_p')
ax = gca ;                   % Get handle to current axes.

ax.XAxis.FontSize = 18;             % Set x and y font sizes.
ax.YAxis.FontSize = 18;
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% 
% 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% FFT 
% % % A=[1 2 3];                       %no of cells
% figure;
% hold on;
% box on;

% K = readmatrix(append('u.csv')) ;

% dt = K(3,1)- K(2,1);        % Assumes uniform sampling
% Fs = 1 / dt;
% L = length(K);           % Signal length
% 
% % Perform FFT
% Y = fft(K( :,2));
% P2 = abs(Y/L);           % Two-sided spectrum
% P1 = P2(1:floor(L/2)+1); % Single-sided spectrum
% P1(2:end-1) = 2*P1(2:end-1);
% 
% % Frequency domain
% f = Fs*(0:floor(L/2))/L;
% 
% % Plot the single-sided amplitude spectrum
% plot(f, P1);
% title('Single-Sided Amplitude Spectrum');
% xlabel('Frequency (Hz)');
% ylabel('|P1(f)|');
% xlim([0 1.6]);    
% ylim([0 0.3]);
% ax = gca ;                   % Get handle to current axes.

% ax.XAxis.FontSize = 18;             % Set x and y font sizes.
% ax.YAxis.FontSize = 18;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%