/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2014-2020 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "IshiiZuberModv.H"
#include "phasePair.H"
#include "addToRunTimeSelectionTable.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
namespace dragModels
{
    defineTypeNameAndDebug(IshiiZuberModv, 0);
    addToRunTimeSelectionTable(dragModel, IshiiZuberModv, dictionary);
}
}


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::dragModels::IshiiZuberModv::IshiiZuberModv
(
    const dictionary& dict,
    const phasePair& pair,
    const bool registerObject
)
:
    dragModel(dict, pair, registerObject)
{}


// * * * * * * * * * * * * * * * * Destructor  * * * * * * * * * * * * * * * //

Foam::dragModels::IshiiZuberModv::~IshiiZuberModv()
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

Foam::tmp<Foam::volScalarField>
Foam::dragModels::IshiiZuberModv::CdRe() const
{
    volScalarField Eo(max(pair_.Eo(), scalar(1e-3)));
    volScalarField d(pair_.dispersed().d());
    volScalarField rho(pair_.continuous().rho());
    volScalarField magUr(pair_.magUr());
    volScalarField Re(max(pair_.Re(), scalar(1e-3)));
    volScalarField alpha1
    (
        max(pair_.dispersed(), pair_.dispersed().residualAlpha())
    );
    //scalarField p; // to get p value from user
    volScalarField correction (pow((1-alpha1), 2));
    volScalarField CdSphere (24.0 / Re * (1. + 0.15 * pow(Re,0.687)));
    volScalarField CdEllipse ((4.0/3.0) * pow(2. * Eo , 0.5));
    // volScalarField CdCap ((8.0/3.0));
    volScalarField Cd (max(CdSphere, min(CdEllipse, 2.666667)));
    return (Cd * correction) * Re ;
}



// ************************************************************************* //
