import matplotlib.colors
import matplotlib.pyplot as plt
import matplotlib.font_manager as fm
import numpy as np
import pandas as pd
import scipy as sp
import os
import fluidfoam as fl
from glob import glob

# Ensure correct rcParams for plotting
plt.rcParams.update({'font.size': 14, 'font.family': 'DejaVu Sans', "text.usetex": False})

# Setting the path variables
Path = r'/home/hellothere/FOSSEE/PorousCylinder/GridConvergence/8k'  # Use raw string for the path
save_path = r'/home/hellothere/FOSSEE/PorousCylinder/GridConvergence/8k'

#checking if path exists
path_namepatch = glob(f'{Path}/**/postProcessing/forceCoeffs/0', recursive=True)
print(f"Found paths: {path_namepatch}")

if not path_namepatch:
    raise FileNotFoundError(f"No directories found for pattern: {Path}/**/postProcessing/forceCoeffs/0")

# Extracting and plotting force coefficient data
# Read force coefficients
forces_Coefficients1 = fl.readpostpro.readforce(Path,
                                                 namepatch='postProcessing/forceCoeffs',
                                                 time_name='latestTime',
                                                 name='coefficient')

# extraction with pandas
Forces1 = pd.DataFrame(forces_Coefficients1, 
                       columns=['Time','Cd','Cdf','Cdr','Cl','Clf','Clr','CmPitch','CmRoll','CmYaw','Cs','Csf','Csr'])

# Compute moving average to smoothen data
window_size = 1000  # Adjust the window size as needed
Forces1['Cl_smooth'] = Forces1['Cl'].rolling(window=window_size).mean()
#printing the data
#print(Forces1)# Filter the DataFrame for the time range between 0.16 ms and 0.25 ms
filtered_forces = Forces1[(Forces1['Time']  >= 100)]
# Extract the 'Cl' values from the filtered DataFrame
Coeff_values = filtered_forces['Cd']
#t = filtered_forces['Time']
# Print the mean drag coefficient
print('Mean Drag Coefficient = ', np.mean(Coeff_values))
# Create a Cd plot
fig, axes = plt.subplots(1,2, figsize=(12, 6))  # Adjusted to a single plot
ax = axes[0]
ax.plot(Forces1.Time, Forces1.Cd, label=r'$Re = 100, D = 500$')
ax.set_xlabel('Time (s)')
ax.set_ylabel('$C_d$')
ax.set_title('Drag Coefficient ($C_d$) vs Time')
# Add legend
ax.legend(loc='upper right', frameon=False)  # or 'best', 'upper right', etc
ax.grid(True)
#ax.set_xlim(200, 250)
ax.set_ylim(1.2, 1.6)

axx = axes[1]
axx.plot(Forces1.Time, Forces1.Cl, label=r'$Re = 100, D = 500$')
#axx.plot(Forces1.Time, Forces1.Cl_smooth, label=r'$Smoothen$')
#axx.axhline(0, color='k', linestyle='--')
axx.set_xlabel('Time (s)')
axx.set_ylabel('$C_l$')
axx.set_title('Lift Coefficient ($C_l$) vs Time')
# Print the mean drag coefficient
print('Mean Lift Coefficient = ', np.mean(Forces1.Cl))
# Add legend
axx.legend(loc='upper right', frameon=False)  # or 'best', 'upper right', etc
axx.grid(True)
#axx.set_xlim(0, 300)
#axx.set_ylim(-0.5, 0.5)

#saving the picture
plt.subplots_adjust(wspace=0.3)  # Adjust the width space between subplots
#plt.savefig(save_path + 'Forces.jpeg', dpi = 300, bbox_inches = 'tight')

# Display the plot
plt.show()
