Info<< "Reading field S\n" << endl;

volScalarField S
(
    IOobject
    (
        "S",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);


Info<< "Reading field U\n" << endl;

volVectorField U
(
    IOobject
    (
        "U",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);


Info<< "Reading transportProperties\n" << endl;

IOdictionary transportProperties
(
    IOobject
    (
        "transportProperties",
        runTime.constant(),
        mesh,
        IOobject::MUST_READ_IF_MODIFIED,
        IOobject::NO_WRITE
    )
);


Info<< "Reading diffusivity DS\n" << endl;

dimensionedScalar DS
(
	"DS",
    transportProperties.lookup("DS")
);

Info<< "Reading source sourceS\n" << endl;

dimensionedScalar sourceS
(
	"sourceS",
    transportProperties.lookup("sourceS")
);


#include "createPhi.H"

#include "createFvModels.H"
#include "createFvConstraints.H"
