// Gaussian random points in plane

// usage:  gaussian_points -N #    

        
// Michel Vallieres 

// This code was downloaed from http://www.physics.drexel.edu/~valliere/PHYS305/Monte_Carlo/random_number// s/gaussian_points.c on 30.3.2021
// The Notes for this code is written on the research Notebook for Abhimanyu
// Code is needed for randomization of velocity distribution

// ******************************** End Note **********************

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

  // uniform random #s in [0,1]
// rand() is a c library code, the variable is uniformly distributed

// ****** define global variables ******//

double gauss1, gauss2;
void gaussian_rand();  

double rand01()

{
 //srand(time(0));
  return (double)rand()/(double)RAND_MAX; //returns the values only between [0 1]; divided by RAND_MAX
}

 // gaussian random # with <x>=1 & sigma=1
  // Koonin & Meredith, 1990

//double gaussian_rand()
void gaussian_rand()
{
  //double twou, radius, theta, gauss1, gauss2;
  double twou, radius, theta;
  double unirand01;
  
  unirand01 = rand01();
//  printf("%lf \n", unirand01);
  twou = -2.0 * log (1.0 - rand01() ); // u is exponentially distributed, 2 is a factor
  radius = sqrt( twou );
  theta = 2 * M_PI * rand01();
  gauss1 = radius * cos(theta);
  gauss2 = radius * sin(theta);
 // return gauss1;
  return;
}



int main( int argc, char * argv[] )
{

 FILE *fout;

  int i;
  int N;

  double M, sigma;

 printf("Type the value of mean (M): \n");
 scanf("%lf", &M);
 printf("Read the value of mean (M):%lf \n", M);
 printf("Type the value of sigma (sigma):\n");
 scanf("%lf", &sigma);
 printf("Read the value of sigma (sigma):%lf \n", sigma);
  
  N = 20; // number of cells that are covering the inlet
  if ( argc == 3 )
    if ( argv[1][0] == '-' && argv[1][1] == 'N' )
      N = atoi( argv[2] );

  fout = fopen("./RanData.txt","w+");
  for ( i=0; i<N; i++ )
    {
      gaussian_rand();
      fprintf( fout, "%f \n", sigma*gauss1+M);

      //fprintf( fout, "%f \n", sigma*gauss2+M); //use any of the two to get the velocities in required directions
   
    }
  fclose(fout);
}
