
from math import sqrt
import numpy as np
import matplotlib.pyplot as plt

gamma = 1.4
R = 287.0

p1=300000
T1=15.0+273.0
u1=0
rho1=p1/(R*T1)
a1=sqrt(gamma*287*T1)

p2=30000
u2=0
T2=15.0+273.0
rho2=p2/(R*T2)
a2=sqrt(gamma*287.0*T2)

a=(gamma-1)/(gamma+1)
b= (gamma+1)/(2*gamma)
c=(gamma-1)/(2*gamma)
d=(gamma-1)/2
e=(2*gamma)/(gamma-1)
f=gamma-1
v3 = 0
v4 = 1
p=0.1
while(True):
    x=(p/p1)
    y=p/p2

    v3 = (2*a1)/(gamma-1) *(1-(x**c))
    M2=sqrt(b*(y+a))
    T4=(((1+d*M2**2)*(e*M2**2 - 1))/(M2**2*(e + d)))*T2
    M4 =sqrt( ((M2**2)*f + 2)/((2*gamma*M2**2)-f))


    vs=M2*a2
    a4=sqrt(gamma*287*T4)
    v4=vs - (M4*a4)
   
    if int(v3) == int(v4):
        
        break
    else:
        p+=1



xl=0.0
xR=0.3
xi=0.15

w=vs
u3=v3
c1=a1
a3=a1*(1-(d)*(v3/a1))
c3=a3
t=0.00025
npts=101

xsh=xi+(w*t)
xcd=xi+(u3*t)
xft=xi+(u3-c3)*t
xhd=xi-(c1*t)

a3=a1*(1-(d)*(v3/a1))
T3=(a3*a3)/(gamma*R)
rho3=p/(R*T3)
rho4=p/(R*T4)
u4=v4
p3=p
p4=p




x_arr = np.linspace(xl, xR, npts)
rho = np.zeros(npts, dtype=float)
p = np.zeros(npts, dtype=float)
u = np.zeros(npts, dtype=float)
gm1 = gamma - 1.
gp1 = gamma + 1.
for i, x in enumerate(x_arr):
        if x < xhd:
            rho[i] = rho1
            p[i] = p1
            u[i] = u1
        elif x < xft:
            u[i] = 2. / gp1 * (c1 + (x - xi) / t)
            fact = 1. - 0.5 * gm1 * u[i] / c1
            rho[i] = rho1 * fact ** (2. / gm1)
            p[i] = p1 * fact ** (2. * gamma / gm1)
        elif x < xcd:
            rho[i] = rho3
            p[i] = p3
            u[i] = u3
        elif x < xsh:
            rho[i] = rho4
            p[i] = p4
            u[i] = u4
        else:
            rho[i] = rho2
            p[i] = p2
            u[i] = u2



T=p/(rho*R)


import csv
with open('of_shock.csv') as csvfile:
    readCSV = csv.reader(csvfile, delimiter=',')
    next(readCSV)
    den=[];vel1=[];vel2=[];vel3=[];pres=[];tem=[];vel=[]
    for row in readCSV:            
            den=np.append(den,row[5])
            vel1=np.append(vel1,row[1])
            vel2=np.append(vel2,row[2])
            vel3=np.append(vel3,row[3]) 
            vel=np.append(vel,row[11])           
            tem=np.append(tem,row[4])
            pres=np.append(pres,row[0])

plt.figure(1)
plt.plot(x_arr, pres, 'k.:',label='OF')
plt.plot(x_arr, p, linewidth=1.5, color='b',label='Analytical')

legend = plt.legend(loc='upper right', shadow=True)
plt.ylabel('pressure (pascal)')
plt.xlabel('x')
plt.ylim([0,350000])
plt.savefig('pressure.eps')
plt.show()

plt.figure(2)
plt.plot(x_arr, u, 'k.:',label='Analytical')
plt.plot(x_arr, vel, linewidth=1.5, color='b',label='OF')

legend = plt.legend(loc='upper left', shadow=True)

plt.ylabel('velocity(m/s)')
plt.xlabel('x')
plt.savefig('velocity.eps')
#plt.ylim([0,500000])
plt.show()


plt.figure(3)
plt.plot(x_arr, den, 'k.:',label='OF')
plt.plot(x_arr, rho, linewidth=1.5, color='b',label='Analytical')
legend = plt.legend(loc='upper right', shadow=True)


plt.ylabel('Density (kg/m3)')
plt.xlabel('x')
plt.savefig('density.eps')

plt.show()


plt.figure(4)
plt.plot(x_arr, tem, 'k.:',label='OF')
plt.plot(x_arr, T, linewidth=1.5, color='b',label='Analytical')
legend = plt.legend(loc='upper left', shadow=True)


plt.ylabel('Temperature(K)')
plt.xlabel('x')
plt.savefig('temperature.eps')

plt.show()

    



