// Gmsh project created on Fri Feb 14 00:04:48 2020

cl1 = 0.04;
cl2 = 0.005;

posx = 1.1;
posy = 0.75;
r  = 0.1;

Point(1) = {0, 0, 0, cl1};
Point(2) = {3, 0, 0, cl1};
Point(3) = {3, 1.5, 0, cl1};
Point(4) = {0, 1.5, 0, cl1};
Line(1) = {1, 2};
Line(2) = {2, 3};
Line(3) = {3, 4};
Line(4) = {4, 1};

Point(5) = {posx, posy, 0, cl2};
Point(6) = {posx+r, posy, 0, cl2};
Point(7) = {posx, posy+r, 0, cl2};
Point(8) = {posx-r, posy, 0, cl2};
Point(9) = {posx, posy-r, 0, cl2};

Circle(5) = {8, 5, 7};
Circle(6) = {7, 5, 6};
Circle(7) = {6, 5, 9};
Circle(8) = {9, 5, 8};

Line Loop(9) = {1, 2, 3, 4};
Line Loop(10) = {7, 8, 5, 6};
Plane Surface(11) = {9, 10};
Extrude {0, 0, 0.1} {
  Surface{11};
  Layers{1};
  Recombine;
}

Physical Surface("inlet") = {36};
Physical Surface("outlet") = {28};
Physical Surface("topAndBottomWalls") = {32, 24};
Physical Surface("frontAndBack") = {11, 53};
Physical Surface("cylwall") = {44, 48, 52, 40};
Physical Volume("internal") = {1};

Point(100) = {1.1, 0.75, 0, cl2};
Point(101) = {1.5, 0.75, 0, cl2};
Line(54) = {100, 101};

Field[1] = Attractor;
Field[1].EdgesList = {54};
Field[1].NNodesByEdge = 100;
Field[2] = Threshold;
Field[2].DistMax = 0.3;
Field[2].DistMin = 0.15;
Field[2].IField = 1;
Field[2].LcMax = 0.1;
Field[2].LcMin = 0.01;
Field[2].StopAtDistMax = 1;
Background Field = 2;